<?php

namespace Import\ApiBundle\Services\DataStructure;


class AllegroDoShowCatDataStructure extends AbstractDataStructure
{
    public $sessionHandle = null;

    public $catId = null;
    public $catItemState = null;
    public $catItemOption = null;
    /**
     * @var CatItemDurationOption
     */
    public $catItemDurationOption;
    /**
     * @var CatAttribFields
     */
    public $catAttribFields;
    public $catSortOptions = null;
    /**
     * @var MinMax
     */
    public $catItemsPrice;
    public $catItemsOffset = null;
    public $catItemsLimit = null;
    public $catOrderFulfillmentTime = null;

    public function __construct()
    {
        $this->catItemDurationOption = new CatItemDurationOption();
        $this->catItemsPrice = new MinMax('price-min','price-max');
        $this->catAttribFields = new CatAttribFields();
    }

    public function validate()
    {
        return (is_null($this->catId) || is_null($this->sessionHandle)) ? false : true;
    }

    public function getTableParam()
    {
        if(!$this->validate())
        {
            return false;
        }
        $return =  array(
            'session-handle' => $this->sessionHandle,
            'cat-id' => $this->catId
        );
        if(!is_null($this->catItemState))
        {
            $return['cat-item-state'] = $this->catItemState;
        }
        if(!is_null($this->catItemOption))
        {
            $return['cat-item-option'] = $this->catItemOption;
        }
        if($this->catItemDurationOption->validate())
        {
            $return['cat-item-duration-option'] = $this->catItemDurationOption->getTableParam();
        }
        if($this->catAttribFields->validate())
        {
            $return['cat-attrib-fields'] = $this->catAttribFields->getTableParam();
        }
        if($this->catAttribFields->validate())
        {
            $return['cat-attrib-fields'] = $this->catAttribFields->getTableParam();
        }
        if(!is_null($this->catSortOptions))
        {
            $return['cat-sort-options'] = $this->catSortOptions;
        }
        if($this->catItemsPrice->validate())
        {
            $return['cat-items-price'] = $this->catItemsPrice->getTableParam('float');
        }
        if(!is_null($this->catItemsOffset))
        {
            $return['cat-items-offset'] = $this->catItemsOffset;
        }
        if(!is_null($this->catItemsLimit))
        {
            $return['cat-items-limit'] = $this->catItemsLimit;
        }
        if(!is_null($this->catOrderFulfillmentTime))
        {
            $return['cat-order-fulfillment-time'] = $this->catOrderFulfillmentTime;
        }

        return $return;
    }
}

class CatItemDurationOption
{
    public $durationOption = null;
    public $durationValue = null;

    public function validate()
    {
        return (is_null($this->durationOption) || is_null($this->durationValue)) ? false : true;
    }

    public function getTableParam()
    {
        if(!$this->validate())
        {
            return false;
        }
        return array(
            'duration-option' => $this->durationOption,
            'duration-value' => $this->durationValue
        );
    }
}

class MinMax
{
    public $min = null;
    public $max = null;

    public $nameMin;
    public $nameMax;

    public function __construct($nameMin = 'min', $nameMax = 'max')
    {
        $this->nameMin = $nameMin;
        $this->nameMax = $nameMax;
    }

    public function validate()
    {
        return (is_null($this->min) && is_null($this->max)) ? false : true;
    }

    public function getTableParam()
    {
        if(!$this->validate())
        {
            return false;
        }
        $arr = array();
        if(!is_null($this->min))
        {
            $arr[$this->nameMin] = $this->min;
        }
        if(!is_null($this->max))
        {
            $arr[$this->nameMax] = $this->max;
        }
        return $arr;
    }
}

class CatAttribFields
{
    private $array = array();

    public function add(CatAttribField $CatAttribField)
    {
        $this->array[] = $CatAttribField;

        return $this;
    }

    public function validate()
    {
        return (count($this->array) == 0) ? false : true;
    }

    public function get()
    {
        return $this->array;
    }

    public function getTableParam()
    {
        if(!$this->validate())
        {
            return false;
        }
        $return = array();
        foreach($this->array as $el)
        {
            if($el->validate())
            {
                $return[] = $el->getTableParam();
            }
        }
        return $return;
    }
}

class CatAttribField
{
    public $fid = null;
    public $fvalueString = null;
    public $fvalueInt = 0;
    public $fvalueFloat = 0;
    public $fvalueImage = '';
    public $fvalueDatetime = 0;
    public $fvalueDate = '';
    /**
     * @var MinMax
     */
    public $fvalueRangeInt;
    /**
     * @var MinMax
     */
    public $fvalueRangeFloat;
    /**
     * @var MinMax
     */
    public $fvalueRangeDate;

    public function __construct()
    {
        $this->fvalueRangeInt = new MinMax('fvalue-range-int-min','fvalue-range-int-max');
        $this->fvalueRangeFloat = new MinMax('fvalue-range-float-min','fvalue-range-float-max');
        $this->fvalueRangeDate = new MinMax('fvalue-range-date-min','fvalue-range-date-max');
    }

    public function validate()
    {
        return (is_null($this->fid) || is_null($this->fvalueString)) ? false : true;
    }

    public function getTableParam()
    {
        if(!$this->validate())
        {
            return false;
        }
        $return = array(
            'fid' => $this->fid,
            'fvalue-string' => $this->fvalueString,
            'fvalue-int' => $this->fvalueInt,
            'fvalue-float' => $this->fvalueFloat,
            'fvalue-image' => $this->fvalueImage,
            'fvalue-datetime' => $this->fvalueDatetime,
            'fvalue-date' => $this->fvalueDate
        );
        if($this->fvalueRangeInt->validate())
        {
            $return['fvalue-range-int'] = $this->fvalueRangeInt->getTableParam();
        }
        if($this->fvalueRangeFloat->validate())
        {
            $return['fvalue-range-float'] = $this->fvalueRangeFloat->getTableParam();
        }
        if($this->fvalueRangeDate->validate())
        {
            $return['fvalue-range-date'] = $this->fvalueRangeDate->getTableParam();
        }

        return $return;
    }
}
